import os
from pprint import pprint
import requests
from dotenv import load_dotenv

load_dotenv()

SHEETY_PRICES_ENDPOINT = "https://api.sheety.co/2c8f8a6fe47964efb55f3d3f55787223/flightDeals/prices"
SHEETY_USERS_ENDPOINT = "https://api.sheety.co/2c8f8a6fe47964efb55f3d3f55787223/flightDeals/users"

sheety_header = {
    "Authorization": f"Bearer {os.environ['BEARER_TOKEN']}"
}

class DataManager:

    def __init__(self):
        self.destination_data = {}

    def get_destination_data(self):
        response = requests.get(url=SHEETY_PRICES_ENDPOINT,headers=sheety_header)
        data = response.json()
        self.destination_data = data["prices"]
        return self.destination_data

    def update_destination_codes(self):
        for city in self.destination_data:
            new_data = {
                "price": {
                    "iataCode": city["iataCode"]
                }
            }
            response = requests.put(
                url=f"{SHEETY_PRICES_ENDPOINT}/{city['id']}",
                json=new_data,
                headers=sheety_header
            )
            print(response.text)

    def get_customer_emails(self):
        customers_endpoint = SHEETY_USERS_ENDPOINT
        response = requests.get(url=customers_endpoint,headers=sheety_header)
        data = response.json()
        self.customer_data = data["users"]
        return self.customer_data